/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.contentAssist;

import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.internal.builder.LocalModule;
import com.aptana.editor.php.internal.contentAssist.ContentAssistUtils;
import com.aptana.editor.php.internal.contentAssist.IDocumentationResolver;
import com.aptana.editor.php.internal.contentAssist.Messages;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.PHPDocUtils;
import com.aptana.editor.php.internal.indexer.PHPTypeProcessor;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import com.aptana.editor.php.internal.parser.phpdoc.FunctionDocumentation;
import com.aptana.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org2.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDoc;

class EntryDocumentationResolver
implements IDocumentationResolver {
    private static final String EMPTY_STRING = "";
    private final String proposalContent;
    private final IElementsIndex index;
    private final Object val;
    private final IElementEntry entry;

    protected EntryDocumentationResolver(String proposalContent, IElementsIndex index, Object val, IElementEntry entry) {
        this.proposalContent = proposalContent;
        this.index = index;
        this.val = val;
        this.entry = entry;
    }

    @Override
    public String resolveDocumentation() {
        IDocument document = this.resolveDocument();
        if (this.val instanceof FunctionPHPEntryValue) {
            FunctionPHPEntryValue pl = (FunctionPHPEntryValue)this.val;
            PHPDocBlock findFunctionPHPDocComment = PHPDocUtils.findFunctionPHPDocComment(this.entry, document, pl.getStartOffset());
            StringBuffer bf = new StringBuffer();
            bf.append(this.proposalContent);
            bf.append('(');
            if (!pl.getParameters().isEmpty()) {
                for (String s : pl.getParameters().keySet()) {
                    bf.append('$');
                    bf.append(s);
                    bf.append(',');
                }
                bf.deleteCharAt(bf.length() - 1);
            }
            bf.append(')');
            String sig = bf.toString();
            FunctionDocumentation parseFunctionPHPDoc = findFunctionPHPDocComment != null ? PHPDocUtils.getFunctionDocumentation((IPHPDoc)findFunctionPHPDocComment) : null;
            String docString = PHPDocUtils.computeDocumentation(parseFunctionPHPDoc, document, sig);
            String typesString = EntryDocumentationResolver.computeEntryTypesDisplayString(this.entry, this.index);
            if (typesString != null && typesString.length() > 0) {
                String resolvedStr = Messages.EntryDocumentationResolver_resolvedReturnTypes;
                docString = String.valueOf(docString) + "<br><b>" + resolvedStr + "</b> " + typesString;
            }
            return docString;
        }
        if (this.val instanceof ClassPHPEntryValue) {
            ClassPHPEntryValue pl = (ClassPHPEntryValue)this.val;
            PHPDocBlock findFunctionPHPDocComment = PHPDocUtils.findFunctionPHPDocComment(this.entry, document, pl.getStartOffset());
            StringBuffer bf = new StringBuffer();
            bf.append(this.proposalContent);
            String sig = bf.toString();
            FunctionDocumentation parseFunctionPHPDoc = findFunctionPHPDocComment != null ? PHPDocUtils.getFunctionDocumentation((IPHPDoc)findFunctionPHPDocComment) : null;
            String docString = PHPDocUtils.computeDocumentation(parseFunctionPHPDoc, document, sig);
            return docString;
        }
        if (this.val instanceof VariablePHPEntryValue) {
            FunctionDocumentation parseFunctionPHPDoc;
            VariablePHPEntryValue pl = (VariablePHPEntryValue)this.val;
            int startOffset = pl.getStartOffset();
            PHPDocBlock findFunctionPHPDocComment = PHPDocUtils.findFunctionPHPDocComment(this.entry, document, startOffset);
            StringBuffer bf = new StringBuffer();
            bf.append(this.proposalContent);
            String sig = bf.toString();
            FunctionDocumentation functionDocumentation = parseFunctionPHPDoc = findFunctionPHPDocComment != null ? PHPDocUtils.getFunctionDocumentation((IPHPDoc)findFunctionPHPDocComment) : null;
            if (pl.isParameter()) {
                parseFunctionPHPDoc = null;
            }
            String docString = PHPDocUtils.computeDocumentation(parseFunctionPHPDoc, document, sig);
            String typesString = EntryDocumentationResolver.computeEntryTypesDisplayString(this.entry, this.index);
            if (typesString != null && typesString.length() > 0) {
                String resolvedStr = Messages.EntryDocumentationResolver_resolvedTypes;
                docString = String.valueOf(docString) + "<br><b>" + resolvedStr + "</b> " + typesString;
            }
            return docString;
        }
        return null;
    }

    protected IDocument resolveDocument() {
        IDocument document = null;
        if (this.entry != null) {
            ISourceViewer sourceViewer;
            IFile moduleFile;
            IEditorPart editor;
            IModule module = this.entry.getModule();
            if (!(module instanceof LocalModule)) {
                return null;
            }
            IWorkbenchPage activePage = UIUtils.getActivePage();
            if (activePage != null && (editor = activePage.findEditor((IEditorInput)new FileEditorInput(moduleFile = ((LocalModule)module).getFile()))) != null && (sourceViewer = (ISourceViewer)editor.getAdapter(ISourceViewer.class)) != null) {
                document = sourceViewer.getDocument();
            }
        }
        return document;
    }

    private static String computeEntryTypesDisplayString(IElementEntry entry, IElementsIndex indexer) {
        Object entryValue = entry.getValue();
        if (entryValue instanceof ClassPHPEntryValue) {
            return EMPTY_STRING;
        }
        if (entryValue instanceof FunctionPHPEntryValue) {
            Set<Object> returnTypes = ((FunctionPHPEntryValue)entryValue).getReturnTypes();
            if (returnTypes == null || returnTypes.size() == 0) {
                return EMPTY_STRING;
            }
            Set<String> resolvedTypes = PHPTypeProcessor.processTypes(returnTypes, indexer);
            if (resolvedTypes.size() == 0) {
                return EMPTY_STRING;
            }
            ArrayList<String> typesList = new ArrayList<String>(resolvedTypes.size());
            typesList.addAll(resolvedTypes);
            return EntryDocumentationResolver.getTypesDisplayString(typesList, entry);
        }
        if (entryValue instanceof VariablePHPEntryValue) {
            Set<Object> variableTypes = ((VariablePHPEntryValue)entryValue).getTypes();
            if (variableTypes == null || variableTypes.size() == 0) {
                return EMPTY_STRING;
            }
            Set<String> resolvedTypes = PHPTypeProcessor.processTypes(variableTypes, indexer);
            if (resolvedTypes.size() == 0) {
                return EMPTY_STRING;
            }
            ArrayList<String> typesList = new ArrayList<String>(resolvedTypes.size());
            typesList.addAll(resolvedTypes);
            return EntryDocumentationResolver.getTypesDisplayString(typesList, entry);
        }
        return EMPTY_STRING;
    }

    private static String getTypesDisplayString(List<String> types, IElementEntry entry) {
        ArrayList<String> sortedTypes = new ArrayList<String>(types.size());
        sortedTypes.addAll(types);
        Collections.sort(sortedTypes);
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < sortedTypes.size() - 1) {
            String type = (String)sortedTypes.get(i);
            result.append(type);
            result.append(", ");
            ++i;
        }
        result.append((String)sortedTypes.get(sortedTypes.size() - 1));
        return ContentAssistUtils.truncateLineIfNeeded(result.toString());
    }

    @Override
    public String getProposalContent() {
        return this.proposalContent;
    }
}

